function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_resid_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 105);

T(1) = (params(2)-1)/params(2);
T(2) = (1-params(11))*exp(T(1)*y(47));
T(3) = exp(y(13))^params(3);
T(4) = exp(y(42));
T(5) = T(4)^(1-params(3));
T(6) = T(3)*T(5);
T(7) = T(6)^T(1);
T(8) = exp(y(39));
T(9) = T(2)*T(7)+params(11)*T(8)^T(1);
T(10) = params(2)/(params(2)-1);
T(11) = 1/params(2);
T(12) = exp(y(40))^T(11);
T(13) = (-1)/params(2);
T(14) = T(8)^T(13);
T(15) = T(12)*exp(T(1)*y(47))*(1-params(11))*(1-params(3));
T(16) = T(6)^T(13);
T(17) = T(4)^(-params(3));
T(18) = T(12)*exp(T(1)*y(47))*(1-params(11))*params(3);
T(19) = exp(y(13))^(params(3)-1);
T(20) = exp(y(41));
T(21) = params(9)^((-1)/params(8));
T(22) = 1/params(8);
T(23) = exp(y(43))-params(9)*T(4)^(1+params(8))/(1+params(8));
T(24) = T(23)^(-params(14));
T(25) = exp(y(15))-params(9)*exp(y(14))^(1+params(8))/(1+params(8));
T(26) = T(25)^(-params(14));
T(27) = params(13)^(1-params(4));
T(28) = params(12)^(1-params(4));
T(29) = T(24)*exp(y(25))*exp(y(28));
T(30) = params(21)^(-1);
T(31) = T(30)*y(19)*(-(exp(y(46))*exp(y(25))*exp(y(11))));
T(32) = exp(y(25))*y(59)+T(31)+T(30)*y(21)*(-(exp(y(25))*exp(y(46))));
T(33) = exp(y(25))*exp(y(28))-exp(y(28))*params(6)*exp(y(55)-y(48))^(params(5)-1);
T(34) = params(21)*y(116)*(-(exp(y(30))*exp((-y(104)))*exp(y(34))));
T(35) = exp(y(30))*y(71)+params(21)*y(109)*exp(y(30))*params(6)*exp(params(5)*(y(34)-y(104)))+params(21)*y(112)*(-(exp(y(30))*(1-exp((-y(104)))*exp(y(34)))))+T(34);
T(36) = params(21)*y(115)*(-(exp(y(35))*exp(y(31))));
T(37) = exp(y(31))*y(70)+params(21)*y(109)*params(6)*exp(params(5)*y(35))*exp(y(31))+params(21)*y(111)*(-((1-exp(y(35)))*exp(y(31))))+T(36);
T(38) = exp(y(32))*y(73)+y(71)*(-(params(7)*exp(y(32))))+params(21)*y(114)*(-((1-params(7))*exp(y(32))));
T(39) = exp(y(33))*y(72)+y(70)*(-(params(7)*exp(y(33))))+params(21)*y(113)*(-((1-params(7))*exp(y(33))));
T(40) = params(21)*y(112)*(-(exp(y(30))*(-(exp((-y(104)))*exp(y(34))))));
T(41) = T(34)+params(21)*y(109)*exp(y(30))*params(6)*params(5)*exp(params(5)*(y(34)-y(104)))+T(40);
T(42) = params(21)^2;
T(43) = exp(y(102))*params(6)*params(5)*(params(5)-1)*exp(y(35)*(params(5)-1));
T(44) = (-(exp(y(102))*(exp(y(35))*exp(y(94))+y(95)*(-exp(y(35)))-params(6)*params(5)*exp(params(5)*y(35)))));
T(45) = params(21)*y(111)*(-(exp(y(31))*(-exp(y(35)))));
T(46) = T(8)*getPowerDeriv(T(8),T(13),1);
T(47) = T(8)*getPowerDeriv(T(8),T(1),1);
T(48) = getPowerDeriv(T(9),T(10),1);
T(49) = exp(y(40))*getPowerDeriv(exp(y(40)),T(11),1);
T(50) = exp(T(1)*y(47))*(1-params(11))*params(3)*T(49);
T(51) = exp(T(1)*y(47))*(1-params(11))*(1-params(3))*T(49);
T(52) = (1-params(11))*exp(T(1)*y(103));
T(53) = exp(y(99))^(1-params(3));
T(54) = T(20)*getPowerDeriv(T(20),params(3),1);
T(55) = T(20)^params(3);
T(56) = T(53)*T(55);
T(57) = getPowerDeriv(T(56),T(1),1);
T(58) = T(52)*T(53)*T(54)*T(57);
T(59) = T(56)^T(1);
T(60) = T(52)*T(59)+params(11)*exp(y(97))^T(1);
T(61) = getPowerDeriv(T(60),T(10),1);
T(62) = exp(y(99))^(-params(3));
T(63) = exp(y(98))^T(11);
T(64) = T(63)*(1-params(11))*(1-params(3))*exp(T(1)*y(103));
T(65) = T(56)^T(13);
T(66) = getPowerDeriv(T(56),T(13),1);
T(67) = T(53)*T(54)*T(66);
T(68) = T(20)^(params(3)-1);
T(69) = T(63)*(1-params(11))*params(3)*exp(T(1)*y(103));
T(70) = T(20)*getPowerDeriv(T(20),params(3)-1,1);
T(71) = (-(T(53)*(T(68)*T(67)*T(69)+T(65)*T(69)*T(70))));
T(72) = T(4)*getPowerDeriv(T(4),1+params(8),1);
T(73) = (-(params(9)*T(72)/(1+params(8))));
T(74) = getPowerDeriv(T(23),(-params(14)),1);
T(75) = T(73)*T(74);
T(76) = (1-params(3))*exp(y(42)*(1-params(3)));
T(77) = (-(exp(T(1)*y(47))*exp(y(13)*params(3))*T(76)));
T(78) = T(4)*getPowerDeriv(T(4),1-params(3),1);
T(79) = getPowerDeriv(T(6),T(13),1);
T(80) = T(3)*T(78)*T(79);
T(81) = (-(T(16)*T(18)*T(19)*T(78)+T(5)*T(19)*T(18)*T(80)));
T(82) = T(4)*getPowerDeriv(T(4),(-params(3)),1);
T(83) = (-(T(17)*T(3)*T(15)*T(80)+T(3)*T(15)*T(16)*T(82)));
T(84) = getPowerDeriv(T(6),T(1),1);
T(85) = T(2)*T(3)*T(78)*T(84);
T(86) = exp(y(100))-params(9)*exp(y(99))^(1+params(8))/(1+params(8));
T(87) = params(1)*T(86)^(-params(14));
T(88) = exp(y(43))*T(74);
T(89) = (-(params(1)*T(88)/T(26)));
T(90) = T(30)*y(18)*(-(exp(y(44))*exp(y(46))));
T(91) = exp(y(45))*getPowerDeriv(exp(y(45)),T(22),1);
T(92) = T(30)*y(21)*(exp(y(46))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(46))*(exp(y(25))-y(37)))+exp(y(46))*y(65)+T(30)*y(18)*(-(exp(y(46))*(1+exp(y(44))-params(10))))+T(30)*y(19)*(-(exp(y(46))*(exp(y(25))*exp(y(11))+y(37)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))))+T(30)*y(20)*(-(y(38)*exp(y(46))*(1-params(7))));
T(93) = T(12)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(47));
T(94) = T(12)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(47));
T(95) = (1-params(11))*T(1)*exp(T(1)*y(47));
T(96) = T(7)*T(95);
T(97) = getPowerDeriv(exp(y(55)-y(48)),params(5)-1,1);
T(98) = (-(exp(y(28))*params(6)*(-exp(y(55)-y(48)))*T(97)));
T(99) = T(24)*T(98);
T(100) = (-(exp(y(6))*exp(y(10))*(-exp((-y(48))))));
T(101) = (-(exp(y(6))*(-(exp(y(10))*(-exp((-y(48))))))));
T(102) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(48)))*(-params(5));
T(103) = y(75)*T(100)+y(71)*T(101)+y(63)*T(102);
T(104) = (-(exp(y(28))*params(6)*exp(y(55)-y(48))*T(97)));
T(105) = exp(y(102))*params(6)*params(5)*exp(y(35)*(params(5)-1))-exp(y(102))*(exp(y(94))-y(95));

end
